<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login/");
    exit();
}
require_once '../conn/config.php';

$total_balance = 45200.50;
$today_payments = 12;
$pending_payouts = 3;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Dashboard | MacraPay</title>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

    <!-- Custom Styles -->
    <link rel="stylesheet" href="../css/styles.css" />
        <!-- Favicon -->
    <link rel="icon" type="image/png" href="../images/logo.png" sizes="32x32" />
    <link rel="apple-touch-icon" href="../images/logo.png" />

   
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>

    <div class="main-content">
        <?php include '../includes/header.php'; ?>

        <div class="content">
            <h1><i class="fas fa-tachometer-alt"></i> Dashboard</h1>
            <p>Welcome back, <strong><?= htmlspecialchars($_SESSION['user_email']) ?></strong>. Here’s your account overview.</p>

            <div class="analytics-cards">
                <div class="card-analytic">
                    <i class="fas fa-wallet icon"></i>
                    <div class="value">KES <?= number_format($total_balance, 2) ?></div>
                    <h3>Available Balance</h3>
                </div>
                <div class="card-analytic">
                    <i class="fas fa-credit-card icon"></i>
                    <div class="value"><?= $today_payments ?></div>
                    <h3>Today's Payments</h3>
                </div>
                <div class="card-analytic">
                    <i class="fas fa-clock icon"></i>
                    <div class="value"><?= $pending_payouts ?></div>
                    <h3>Pending Payouts</h3>
                </div>
            </div>

            <div class="table-placeholder">
                <em>Recent transactions will appear here.</em>
            </div>
        </div>
    </div>

    <script>
        // Mobile Menu Toggle
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.querySelector('.sidebar');
        if (menuToggle) {
            menuToggle.addEventListener('click', () => {
                sidebar.classList.toggle('active');
            });
        }

        // Close dropdowns when clicking outside
        function closeDropdowns(except) {
            document.querySelectorAll('.dropdown').forEach(d => {
                if (d !== except) d.style.display = 'none';
            });
        }

        // Notification Dropdown
        const notifyBtn = document.getElementById('notifyBtn');
        const notifyDropdown = document.querySelector('.notify-dropdown');
        if (notifyBtn) {
            notifyBtn.addEventListener('click', (e) => {
                e.stopPropagation();
                notifyDropdown.style.display = notifyDropdown.style.display === 'block' ? 'none' : 'block';
                closeDropdowns(notifyDropdown);
            });
        }

        // User Dropdown
        const userMenuBtn = document.getElementById('userMenuBtn');
        const userDropdown = document.querySelector('.user-dropdown');
        if (userMenuBtn) {
            userMenuBtn.addEventListener('click', (e) => {
                e.stopPropagation();
                userDropdown.style.display = userDropdown.style.display === 'block' ? 'none' : 'block';
                closeDropdowns(userDropdown);
            });
        }

        // Close on outside click
        document.addEventListener('click', () => {
            notifyDropdown.style.display = 'none';
            userDropdown.style.display = 'none';
        });
    </script>
</body>
</html>