<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login/");
    exit();
}

$invoice = $_GET['invoice'] ?? 'Unknown';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Payment Success | MacraPay</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link rel="stylesheet" href="../../css/styles.css" />
</head>
<body>
    <?php include '../../includes/sidebar.php'; ?>
    <div class="main-content">
        <?php include '../../includes/header.php'; ?>
        <div class="content">
            <div class="container text-center">
                <div style="max-width: 500px; margin: 0 auto;">
                    <i class="fas fa-check-circle" style="font-size: 5rem; color: #28a745; margin-bottom: 1rem;"></i>
                    <h1>Payment Successful!</h1>
                    <p class="mb-3">Your payment has been received successfully.</p>
                    <p><strong>Invoice ID:</strong> <?= htmlspecialchars($invoice) ?></p>
                    <a href="../../dashboard/" class="btn btn-primary">
                        <i class="fas fa-tachometer-alt"></i> Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>