<?php
// api/payment/balance.php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

require_once '../../conn/config.php';

$user_id = $_SESSION['user_id'];

// Get latest balance
$stmt = $conn->prepare("SELECT balance_after, created_at FROM transactions WHERE user_id = ? AND balance_after IS NOT NULL ORDER BY created_at DESC LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode([
        'balance' => $row['balance_after'],
        'as_of' => $row['created_at']
    ]);
} else {
    echo json_encode([
        'balance' => 0,
        'as_of' => null
    ]);
}

$stmt->close();
$conn->close();