<?php
// api/payment/config.php

// Load environment variables
$envPath = __DIR__ . '/../../.env';
if (!file_exists($envPath)) {
    http_response_code(500);
    die(json_encode(['error' => '.env file not found']));
}

$env = parse_ini_file($envPath);

define('INTASEND_PUBLISHABLE_KEY', $env['INTASEND_PUBLISHABLE_KEY'] ?? '');
define('INTASEND_API_KEY', $env['INTASEND_API_KEY'] ?? '');
define('INTASEND_TEST_MODE', filter_var($env['INTASEND_TEST_MODE'] ?? 'true', FILTER_VALIDATE_BOOLEAN));
define('INTASEND_CALLBACK_URL', $env['INTASEND_CALLBACK_URL'] ?? 'https://pay.macrapay.com/api/payment/callback.php');

// Validate keys
if (!INTASEND_PUBLISHABLE_KEY || !INTASEND_API_KEY) {
    http_response_code(500);
    die(json_encode(['error' => 'IntaSend API keys are missing.']));
}