<?php
// api/payment/status.php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

$invoice_id = $_GET['invoice_id'] ?? null;

if (!$invoice_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing invoice_id']);
    exit();
}

// Connect to DB
require_once '../../conn/config.php';

// Check transactions table (where we insert first)
$stmt = $conn->prepare("SELECT status FROM transactions WHERE description LIKE ? LIMIT 1");
$search_term = "%Invoice: " . $invoice_id . "%";
$stmt->bind_param("s", $search_term);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    echo json_encode([
        'status' => $row['status']
    ]);
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Invoice not found']);
}

$stmt->close();
$conn->close();